﻿var alink = document.getElementsByClassName("link")[0];
var span = alink.childNodes[1];
if (span)
    span.innerText = "";

var head = document.querySelector("head");
var icons = head.querySelectorAll("link[rel='icon']");
for (let i = 0; i < icons.length; i++) {
    head.removeChild(icons[i]);
}

var icon = document.createElement("link");
icon.rel = "icon";
icon.href = 'ext/Acuity4-WebAPI-favicon-ico';
head.appendChild(icon);

var authObserver = document.querySelector(".auth-wrapper");

new MutationObserver(function (mutations) {
    const authInput = authObserver.querySelector(".auth-container input[type=text]");

    if (authInput && !authObserver.querySelector("select")) {
        authInput.setAttribute("readonly", true);

        const authDropdown = document.createElement("select");
        addOption(authDropdown, "Client", "Client");
        addOption(authDropdown, "Panelist", "Panelist");

        const authKey = document.createElement("input");
        authKey.setAttribute("placeholder", "Insert API Access Key");
        authKey.setAttribute("required", true);
        authKey.style.marginLeft = "8px";

        const headerLabel = document.createElement("p");
        headerLabel.innerText = "Use this Authorization header value to authenticate your requests:";
        headerLabel.style.marginTop = "8px";

        authInput.value = authDropdown.value + " " + authKey.value;

        authDropdown.addEventListener("change", function(e) {
            setNativeValue(authInput, authDropdown.value + " " + authKey.value);
            dispatchSimulatedEvent(authInput, "input");
        });

        authKey.addEventListener("input", function (e) {
            setNativeValue(authInput, authDropdown.value + " " + authKey.value);
            authInput.style.display = authKey.value ? "block" : "none";
            headerLabel.style.display = authInput.style.display;
            dispatchSimulatedEvent(authInput, "input");
        });

        authInput.style.display = authKey.value ? "block" : "none";
        headerLabel.style.display = authInput.style.display;

        const authParent = authInput.parentNode;

        authParent.insertBefore(authDropdown, authInput);
        authParent.insertBefore(authKey, authInput);
        authParent.insertBefore(headerLabel, authInput);
    }
}).observe(authObserver, { attributes: false, childList: true, subtree: true });

function addOption(select, value, text) {
    const option = document.createElement("option");
    option.value = value;
    option.text = text;
    select.appendChild(option);
}

function setNativeValue(element, value) {
    const valueSetter = Object.getOwnPropertyDescriptor(element, 'value').set;
    const prototype = Object.getPrototypeOf(element);
    const prototypeValueSetter = Object.getOwnPropertyDescriptor(prototype, 'value').set;

    if (valueSetter && valueSetter !== prototypeValueSetter) {
        prototypeValueSetter.call(element, value);
    } else {
        valueSetter.call(element, value);
    }
}

function dispatchSimulatedEvent(elem, type) {
    const ev = new Event(type, { bubbles: true });
    ev.simulated = true;
    elem.dispatchEvent(ev);
}